/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import java.util.Iterator;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIRangedAttack;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTREntityWindDwarfWarrior;
import lotr.common.entity.projectile.LOTREntityFirePotDwarven;
import lotr.common.entity.projectile.LOTREntityThrowingAxe2;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class LOTREntityWindDwarfAxeThrower
extends LOTREntityWindDwarfWarrior {
    public EntityAIBase rangedAttackAI = this.createRangedAttackAI();
    public EntityAIBase meleeAttackAI;
    private boolean usedFirePot = false;

    public LOTREntityWindDwarfAxeThrower(World world) {
        super(world);
    }

    @Override
    protected EntityAIBase getDwarfAttackAI() {
        this.meleeAttackAI = super.getDwarfAttackAI();
        return this.meleeAttackAI;
    }

    protected EntityAIBase createRangedAttackAI() {
        return new LOTREntityAIRangedAttack(this, 1.25, 30, 12.0f);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(npcRangedAccuracy).func_111128_a(0.76);
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        this.npcItemsInv.setMeleeWeapon(new ItemStack(LOTRMod.battleaxeDwarven));
        this.npcItemsInv.setRangedWeapon(new ItemStack(LOTRMod.throwingAxeDwarven));
        this.npcItemsInv.setIdleItem(new ItemStack(LOTRMod.throwingAxeDwarven));
        return data;
    }

    @Override
    public void onAttackModeChange(LOTREntityNPC.AttackMode mode, boolean mounted) {
        if (mode == LOTREntityNPC.AttackMode.IDLE) {
            if (this.meleeAttackAI != null && this.field_70714_bg.field_75782_a.contains(this.meleeAttackAI)) {
                this.removeTask(this.meleeAttackAI);
            }
            if (this.rangedAttackAI != null && this.field_70714_bg.field_75782_a.contains(this.rangedAttackAI)) {
                this.removeTask(this.rangedAttackAI);
            }
            this.func_70062_b(0, this.npcItemsInv.getIdleItem());
        }
        if (mode == LOTREntityNPC.AttackMode.MELEE) {
            if (this.rangedAttackAI != null && this.field_70714_bg.field_75782_a.contains(this.rangedAttackAI)) {
                this.removeTask(this.rangedAttackAI);
            }
            if (this.meleeAttackAI != null) {
                this.field_70714_bg.func_75776_a(2, this.meleeAttackAI);
            }
            this.func_70062_b(0, this.npcItemsInv.getMeleeWeapon());
        }
        if (mode == LOTREntityNPC.AttackMode.RANGED) {
            if (this.meleeAttackAI != null && this.field_70714_bg.field_75782_a.contains(this.meleeAttackAI)) {
                this.removeTask(this.meleeAttackAI);
            }
            if (this.rangedAttackAI != null) {
                this.field_70714_bg.func_75776_a(2, this.rangedAttackAI);
            }
            this.func_70062_b(0, this.npcItemsInv.getRangedWeapon());
        }
    }

    private void removeTask(EntityAIBase task) {
        if (task != null) {
            Iterator iterator = this.field_70714_bg.field_75782_a.iterator();
            while (iterator.hasNext()) {
                EntityAIBase entry = (EntityAIBase)iterator.next();
                if (entry != task) continue;
                iterator.remove();
                break;
            }
        }
    }

    @Override
    public void func_82196_d(EntityLivingBase target, float f) {
        if (target == null) {
            return;
        }
        double distance = this.func_70032_d((Entity)target);
        if (distance <= 4.0) {
            this.onAttackModeChange(LOTREntityNPC.AttackMode.MELEE, false);
            this.func_70062_b(0, this.npcItemsInv.getMeleeWeapon());
            return;
        }
        if (!this.usedFirePot && !target.func_70027_ad()) {
            this.func_70062_b(0, new ItemStack(LOTRMod.rhunFirePotDwarven));
            LOTREntityFirePotDwarven firePot = new LOTREntityFirePotDwarven(this.field_70170_p, (EntityLivingBase)this);
            firePot.func_70186_c(target.field_70165_t - this.field_70165_t, target.field_70163_u - this.field_70163_u, target.field_70161_v - this.field_70161_v, 1.0f, 0.5f);
            this.field_70170_p.func_72838_d((Entity)firePot);
            this.usedFirePot = true;
        } else {
            this.func_70062_b(0, this.npcItemsInv.getRangedWeapon());
            ItemStack axeItem = this.npcItemsInv.getRangedWeapon();
            if (axeItem == null) {
                axeItem = new ItemStack(LOTRMod.throwingAxeDwarven);
            }
            LOTREntityThrowingAxe2 axe = new LOTREntityThrowingAxe2(this.field_70170_p, (EntityLivingBase)this, target, axeItem, 1.0f, (float)this.func_110148_a(npcRangedAccuracy).func_111126_e());
            this.field_70170_p.func_72838_d((Entity)axe);
        }
        this.func_85030_a("random.bow", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        this.func_71038_i();
    }

    @Override
    public double getMeleeRange() {
        EntityLivingBase target = this.func_70638_az();
        if (target != null && target.func_70027_ad()) {
            return 4.0;
        }
        return super.getMeleeRange();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70638_az() != null && !this.func_70638_az().func_70027_ad()) {
            this.usedFirePot = false;
        }
    }
}

